(function(blocks, element, components, blockEditor) {
    var el = element.createElement;
    var useState = element.useState;
    var useEffect = element.useEffect;
    var SelectControl = components.SelectControl;
    var TextControl = components.TextControl;
    var PanelBody = components.PanelBody;
    var Spinner = components.Spinner;
    var InspectorControls = blockEditor.InspectorControls;

    blocks.registerBlockType('formomatic/form', {
        title: 'FormOMatic',
        icon: 'feedback',
        category: 'embed',
        keywords: ['form', 'formomatic', 'google', 'embed', 'contact'],
        description: 'Embed a FormOMatic form',

        attributes: {
            formId: {
                type: 'string',
                default: ''
            }
        },

        edit: function(props) {
            var formId = props.attributes.formId;
            var _useState = useState([]);
            var forms = _useState[0];
            var setForms = _useState[1];
            var _useState2 = useState(true);
            var loading = _useState2[0];
            var setLoading = _useState2[1];
            var _useState3 = useState(null);
            var error = _useState3[0];
            var setError = _useState3[1];

            // Fetch forms on mount
            useEffect(function() {
                if (!formomaticBlock.apiKey) {
                    setLoading(false);
                    setError('No API key configured. Go to FormOMatic settings to add your API key.');
                    return;
                }

                fetch(formomaticBlock.ajaxUrl + '?action=formomatic_get_forms&nonce=' + formomaticBlock.nonce)
                    .then(function(response) { return response.json(); })
                    .then(function(data) {
                        setLoading(false);
                        if (data.success) {
                            setForms(data.data || []);
                        } else {
                            setError(data.data || 'Failed to load forms');
                        }
                    })
                    .catch(function(err) {
                        setLoading(false);
                        setError('Failed to connect to FormOMatic');
                    });
            }, []);

            function onChangeFormId(newId) {
                props.setAttributes({ formId: newId });
            }

            // Build options for select
            var options = [{ label: '— Select a form —', value: '' }];
            forms.forEach(function(form) {
                options.push({ label: form.name, value: form.id });
            });

            // Find selected form name
            var selectedForm = forms.find(function(f) { return f.id === formId; });

            // Editor preview
            var preview;
            if (loading) {
                preview = el('div', {
                    style: {
                        background: '#f5f5f5',
                        padding: '40px 20px',
                        borderRadius: '8px',
                        textAlign: 'center'
                    }
                },
                    el(Spinner),
                    el('p', { style: { marginTop: '10px', color: '#666' } }, 'Loading forms...')
                );
            } else if (error) {
                preview = el('div', {
                    style: {
                        background: '#fef2f2',
                        border: '1px solid #fecaca',
                        padding: '20px',
                        borderRadius: '8px',
                        textAlign: 'center',
                        color: '#991b1b'
                    }
                },
                    el('p', { style: { margin: 0 } }, error)
                );
            } else if (formId && selectedForm) {
                preview = el('div', {
                    style: {
                        background: 'linear-gradient(135deg, #4a9d7e 0%, #38a169 100%)',
                        color: 'white',
                        padding: '40px 20px',
                        borderRadius: '8px',
                        textAlign: 'center'
                    }
                },
                    el('div', {
                        style: { fontSize: '24px', marginBottom: '8px' }
                    }, 'FormOMatic Form'),
                    el('div', {
                        style: { fontSize: '18px', opacity: 0.95 }
                    }, selectedForm.name),
                    el('div', {
                        style: { marginTop: '16px', fontSize: '12px', opacity: 0.7 }
                    }, 'Form will appear here on the frontend')
                );
            } else if (formId) {
                // Manual ID entered
                preview = el('div', {
                    style: {
                        background: 'linear-gradient(135deg, #4a9d7e 0%, #38a169 100%)',
                        color: 'white',
                        padding: '40px 20px',
                        borderRadius: '8px',
                        textAlign: 'center'
                    }
                },
                    el('div', {
                        style: { fontSize: '24px', marginBottom: '8px' }
                    }, 'FormOMatic Form'),
                    el('div', {
                        style: { opacity: 0.9, fontSize: '14px' }
                    }, 'Form ID: ' + formId),
                    el('div', {
                        style: { marginTop: '16px', fontSize: '12px', opacity: 0.7 }
                    }, 'Form will appear here on the frontend')
                );
            } else {
                // Show form selector directly in the block when no form is selected
                preview = el('div', {
                    style: {
                        background: '#f5f5f5',
                        border: '2px dashed #ccc',
                        padding: '30px 20px',
                        borderRadius: '8px',
                        textAlign: 'center',
                        color: '#666'
                    }
                },
                    el('div', {
                        style: { fontSize: '18px', marginBottom: '16px' }
                    }, 'FormOMatic Form'),
                    forms.length > 0
                        ? el('div', { style: { maxWidth: '300px', margin: '0 auto' } },
                            el(SelectControl, {
                                value: formId,
                                options: options,
                                onChange: onChangeFormId,
                                __nextHasNoMarginBottom: true
                            })
                        )
                        : el(TextControl, {
                            placeholder: 'Enter Form ID',
                            value: formId,
                            onChange: onChangeFormId,
                            __nextHasNoMarginBottom: true
                        })
                );
            }

            return el('div', {},
                el(InspectorControls, {},
                    el(PanelBody, { title: 'Form Settings', initialOpen: true },
                        forms.length > 0 && el(SelectControl, {
                            label: 'Select Form',
                            value: formId,
                            options: options,
                            onChange: onChangeFormId
                        }),
                        el(TextControl, {
                            label: forms.length > 0 ? 'Or enter Form ID manually' : 'Form ID',
                            help: 'Enter your FormOMatic form ID',
                            value: formId,
                            onChange: onChangeFormId
                        }),
                        !formomaticBlock.apiKey && el('p', {
                            style: { color: '#b91c1c', fontSize: '12px' }
                        }, 'Add your API key in FormOMatic settings to see your forms here.')
                    )
                ),
                preview
            );
        },

        save: function() {
            // Rendered via PHP
            return null;
        }
    });
})(
    window.wp.blocks,
    window.wp.element,
    window.wp.components,
    window.wp.blockEditor
);
